/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.MageIdentifier;
import mage.abilities.Ability;
import mage.abilities.costs.Costs;
import mage.abilities.costs.CostsImpl;
import mage.abilities.costs.common.ExileFromGraveCost;
import mage.abilities.costs.mana.ManaCosts;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInYourGraveyard;

class SqueeDubiousMonarchEffect
extends AsThoughEffectImpl {
    private static final FilterCard filter = new FilterCard("other cards from your graveyard");

    public SqueeDubiousMonarchEffect() {
        super(AsThoughEffectType.CAST_FROM_NOT_OWN_HAND_ZONE, Duration.EndOfGame, Outcome.Benefit);
        this.staticText = "you may cast {this} from your graveyard by paying {3}{R} and exiling four other cards from your graveyard rather than paying its mana cost";
    }

    private SqueeDubiousMonarchEffect(SqueeDubiousMonarchEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public SqueeDubiousMonarchEffect copy() {
        return new SqueeDubiousMonarchEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        if (!source.getSourceId().equals(objectId) || !source.isControlledBy(affectedControllerId) || game.getState().getZone(objectId) != Zone.GRAVEYARD) {
            return false;
        }
        Player controller = game.getPlayer(affectedControllerId);
        if (controller == null) {
            return false;
        }
        CostsImpl costs = new CostsImpl();
        costs.add((Object)new ExileFromGraveCost(new TargetCardInYourGraveyard(4, filter)));
        controller.setCastSourceIdWithAlternateMana(objectId, (ManaCosts)new ManaCostsImpl("{3}{R}"), (Costs)costs, MageIdentifier.SqueeDubiousMonarchAlternateCast);
        return true;
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
    }
}

