/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.abilities.keyword.CyclingAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;

class StabilizerEffect
extends ContinuousRuleModifyingEffectImpl {
    StabilizerEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = "Players can't cycle cards";
    }

    private StabilizerEffect(StabilizerEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public StabilizerEffect copy() {
        return new StabilizerEffect(this);
    }

    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        MageObject mageObject = game.getObject(source);
        if (mageObject == null) {
            return null;
        }
        return "You can't cycle cards (" + mageObject.getIdName() + ").";
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ACTIVATE_ABILITY;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Ability ability = game.getAbility(event.getTargetId(), event.getSourceId()).orElse(null);
        return ability instanceof CyclingAbility;
    }
}

