/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Arrays;
import java.util.LinkedHashSet;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class StaffOfTheLetterMagusChooseLetterEffect
extends OneShotEffect {
    StaffOfTheLetterMagusChooseLetterEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose a consonant other than N, R, S, or T";
    }

    private StaffOfTheLetterMagusChooseLetterEffect(StaffOfTheLetterMagusChooseLetterEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent mageObject = game.getPermanentEntering(source.getSourceId());
        if (mageObject == null) {
            mageObject = game.getObject(source);
        }
        ChoiceImpl choice = new ChoiceImpl(true);
        choice.setMessage("Choose letter");
        LinkedHashSet<String> choices = new LinkedHashSet<String>();
        Object[] forbiddenChars = new Character[]{Character.valueOf('A'), Character.valueOf('E'), Character.valueOf('I'), Character.valueOf('N'), Character.valueOf('O'), Character.valueOf('R'), Character.valueOf('S'), Character.valueOf('T'), Character.valueOf('U')};
        Character letter = Character.valueOf('A');
        while (letter.charValue() <= 'Z') {
            if (Arrays.binarySearch(forbiddenChars, letter) < 0) {
                choices.add(letter.toString());
            }
            Character c = letter;
            Character c2 = letter = Character.valueOf((char)(letter.charValue() + '\u0001'));
        }
        choice.setChoices(choices);
        if (controller != null && mageObject != null && controller.choose(this.outcome, (Choice)choice, game)) {
            if (!game.isSimulation()) {
                game.informPlayers(mageObject.getLogName() + ": " + controller.getLogName() + " has chosen " + choice.getChoice());
            }
            game.getState().setValue(mageObject.getId() + "_letter", (Object)choice.getChoice());
            if (mageObject instanceof Permanent) {
                mageObject.addInfo("chosen letter", CardUtil.addToolTipMarkTags((String)("Chosen letter: " + choice.getChoice())), game);
            }
            return true;
        }
        return false;
    }

    public StaffOfTheLetterMagusChooseLetterEffect copy() {
        return new StaffOfTheLetterMagusChooseLetterEffect(this);
    }
}

