/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class StalwartSuccessorWatcher
extends Watcher {
    private final Map<MageObjectReference, UUID> map = new HashMap<MageObjectReference, UUID>();

    StalwartSuccessorWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.COUNTERS_ADDED) {
            if (game.getPermanent(event.getTargetId()) == null) {
                Permanent permanent = game.getPermanentEntering(event.getTargetId());
                this.map.putIfAbsent(new MageObjectReference(event.getTargetId(), permanent.getZoneChangeCounter(game) + 1, game), event.getId());
            }
            this.map.putIfAbsent(new MageObjectReference(event.getTargetId(), game), event.getId());
        }
    }

    public void reset() {
        super.reset();
        this.map.clear();
    }

    static boolean checkCreature(Permanent permanent, GameEvent event, Game game) {
        return Objects.equals(event.getId(), ((StalwartSuccessorWatcher)game.getState().getWatcher(StalwartSuccessorWatcher.class)).map.getOrDefault(new MageObjectReference((MageObject)permanent, game), null));
    }
}

