/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.SacrificeSourceEffect;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.token.Token;

class StanggTwinLeavesTriggeredAbility
extends DelayedTriggeredAbility {
    private final Set<UUID> tokenIds = new HashSet<UUID>();

    StanggTwinLeavesTriggeredAbility(Token token) {
        super((Effect)new SacrificeSourceEffect(), Duration.Custom, false);
        this.tokenIds.addAll(token.getLastAddedTokenIds());
    }

    private StanggTwinLeavesTriggeredAbility(StanggTwinLeavesTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
        this.tokenIds.addAll(ability.tokenIds);
    }

    public StanggTwinLeavesTriggeredAbility copy() {
        return new StanggTwinLeavesTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (this.tokenIds.contains(event.getTargetId()) && ((ZoneChangeEvent)event).getFromZone() == Zone.BATTLEFIELD) {
            this.tokenIds.remove(event.getTargetId());
            return true;
        }
        return false;
    }

    public boolean isInactive(Game game) {
        return this.tokenIds.isEmpty();
    }

    public String getRule() {
        return "Sacrifice {this} when that token leaves the battlefield.";
    }
}

