/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.PermanentsOnTheBattlefieldCondition;
import mage.abilities.decorator.ConditionalContinuousEffect;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.ReturnFromGraveyardToBattlefieldTargetEffect;
import mage.abilities.triggers.BeginningOfUpkeepTriggeredAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.constants.TargetController;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.common.FilterEnchantmentPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

public final class StarfieldOfNyx
extends CardImpl {
    private static final String rule1 = "As long as you control five or more enchantments, each other non-Aura enchantment you control is a creature in addition to its other types and has base power and base toughness each equal to its mana value.";
    private static final FilterCard filterGraveyardEnchantment = new FilterCard("enchantment card from your graveyard");
    private static final FilterEnchantmentPermanent filterEnchantmentYouControl = new FilterEnchantmentPermanent("enchantment you control");

    public StarfieldOfNyx(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{4}{W}");
        BeginningOfUpkeepTriggeredAbility ability = new BeginningOfUpkeepTriggeredAbility((Effect)new ReturnFromGraveyardToBattlefieldTargetEffect(), true);
        ability.addTarget((Target)new TargetCardInYourGraveyard(filterGraveyardEnchantment));
        this.addAbility((Ability)ability);
        ConditionalContinuousEffect effect = new ConditionalContinuousEffect((ContinuousEffect)new StarfieldOfNyxEffect(), (Condition)new PermanentsOnTheBattlefieldCondition((FilterPermanent)filterEnchantmentYouControl, ComparisonType.MORE_THAN, 4), rule1);
        this.addAbility((Ability)new SimpleStaticAbility((Effect)effect));
    }

    private StarfieldOfNyx(StarfieldOfNyx card) {
        super((CardImpl)card);
    }

    public StarfieldOfNyx copy() {
        return new StarfieldOfNyx(this);
    }

    static {
        filterEnchantmentYouControl.add((ObjectSourcePlayerPredicate)TargetController.YOU.getControllerPredicate());
        filterGraveyardEnchantment.add((Predicate)CardType.ENCHANTMENT.getPredicate());
    }

    static class StarfieldOfNyxEffect
    extends ContinuousEffectImpl {
        private static final FilterControlledPermanent filter = new FilterControlledPermanent("Each other non-Aura enchantment you control");

        public StarfieldOfNyxEffect() {
            super(Duration.WhileOnBattlefield, Outcome.BecomeCreature);
            this.staticText = "Each other non-Aura enchantment you control is a creature in addition to its other types and has base power and toughness each equal to its mana value";
            this.dependendToTypes.add(DependencyType.EnchantmentAddingRemoving);
            this.dependendToTypes.add(DependencyType.AuraAddingRemoving);
            this.dependendToTypes.add(DependencyType.BecomeForest);
            this.dependendToTypes.add(DependencyType.BecomeMountain);
            this.dependendToTypes.add(DependencyType.BecomePlains);
            this.dependendToTypes.add(DependencyType.BecomeSwamp);
            this.dependendToTypes.add(DependencyType.BecomeIsland);
            this.dependencyTypes.add(DependencyType.BecomeCreature);
        }

        private StarfieldOfNyxEffect(StarfieldOfNyxEffect effect) {
            super((ContinuousEffectImpl)effect);
        }

        public StarfieldOfNyxEffect copy() {
            return new StarfieldOfNyxEffect(this);
        }

        public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
            for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), source, game)) {
                switch (layer) {
                    case TypeChangingEffects_4: {
                        if (sublayer != SubLayer.NA || permanent.isCreature(game) || permanent.hasSubtype(SubType.AURA, game)) break;
                        permanent.addCardType(game, new CardType[]{CardType.CREATURE});
                        break;
                    }
                    case PTChangingEffects_7: {
                        if (sublayer != SubLayer.SetPT_7b || !permanent.isCreature(game) || permanent.hasSubtype(SubType.AURA, game)) break;
                        int manaCost = permanent.getManaValue();
                        permanent.getPower().setModifiedBaseValue(manaCost);
                        permanent.getToughness().setModifiedBaseValue(manaCost);
                    }
                }
            }
            return true;
        }

        public boolean apply(Game game, Ability source) {
            return false;
        }

        public boolean hasLayer(Layer layer) {
            return layer == Layer.PTChangingEffects_7 || layer == Layer.TypeChangingEffects_4;
        }

        static {
            filter.add((Predicate)CardType.ENCHANTMENT.getPredicate());
            filter.add(Predicates.not((Predicate)SubType.AURA.getPredicate()));
            filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
        }
    }
}

