/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.events.NumberOfTriggersEvent;

class StarfieldVocalistEffect
extends ReplacementEffectImpl {
    StarfieldVocalistEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "if a permanent entering the battlefield causes a triggered ability of a permanent you control to trigger, that ability triggers an additional time";
    }

    private StarfieldVocalistEffect(StarfieldVocalistEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public StarfieldVocalistEffect copy() {
        return new StarfieldVocalistEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.NUMBER_OF_TRIGGERS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!source.isControlledBy(event.getPlayerId())) return false;
        if (!Optional.ofNullable(event).filter(NumberOfTriggersEvent.class::isInstance).map(NumberOfTriggersEvent.class::cast).map(NumberOfTriggersEvent::getSourceEvent).filter(EntersTheBattlefieldEvent.class::isInstance).isPresent()) return false;
        if (game.getPermanent(event.getSourceId()) == null) return false;
        return true;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(event.getAmount() + 1);
        return false;
    }
}

