/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class StarkeOfRathControlEffect
extends ContinuousEffectImpl {
    StarkeOfRathControlEffect() {
        super(Duration.Custom, Layer.ControlChangingEffects_2, SubLayer.NA, Outcome.GainControl);
        this.staticText = "That permanent's controller gains control of {this}";
    }

    private StarkeOfRathControlEffect(StarkeOfRathControlEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public StarkeOfRathControlEffect copy() {
        return new StarkeOfRathControlEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        Player newController = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (permanent != null && newController != null) {
            return permanent.changeControllerId(newController.getId(), game, source);
        }
        this.discard();
        return false;
    }
}

