/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DestroyAllEffect;
import mage.cards.s.SteelHellkiteWatcher;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterNonlandPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.util.CardUtil;

class SteelHellkiteDestroyEffect
extends OneShotEffect {
    SteelHellkiteDestroyEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy each nonland permanent with mana value X whose controller was dealt combat damage by {this} this turn";
    }

    private SteelHellkiteDestroyEffect(SteelHellkiteDestroyEffect effect) {
        super((OneShotEffect)effect);
    }

    public SteelHellkiteDestroyEffect copy() {
        return new SteelHellkiteDestroyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        SteelHellkiteWatcher watcher = (SteelHellkiteWatcher)game.getState().getWatcher(SteelHellkiteWatcher.class);
        if (watcher == null || watcher.getDamagedPlayers(source.getSourceId()).isEmpty()) {
            return false;
        }
        HashSet<ControllerIdPredicate> predicateSet = new HashSet<ControllerIdPredicate>();
        for (UUID playerId : watcher.getDamagedPlayers(source.getSourceId())) {
            predicateSet.add(new ControllerIdPredicate(playerId));
        }
        FilterNonlandPermanent filter = new FilterNonlandPermanent();
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.EQUAL_TO, ((Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0)).intValue()));
        filter.add(Predicates.or(predicateSet));
        return new DestroyAllEffect((FilterPermanent)filter).apply(game, source);
    }
}

