/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SteelSquirrelEffect
extends OneShotEffect {
    SteelSquirrelEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} gets +X/+X until end of turn, where X is the result";
    }

    private SteelSquirrelEffect(SteelSquirrelEffect effect) {
        super((OneShotEffect)effect);
    }

    public SteelSquirrelEffect copy() {
        return new SteelSquirrelEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getSourceId());
        Integer amount = (Integer)this.getValue("rolled");
        if (controller != null && permanent != null && amount != null) {
            game.addEffect((ContinuousEffect)new BoostSourceEffect(amount.intValue(), amount.intValue(), Duration.EndOfTurn), source);
            return true;
        }
        return false;
    }
}

