/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class SteelcladSerpentEffect
extends RestrictionEffect {
    private static final FilterControlledPermanent filter = new FilterControlledPermanent("another artifact");

    public SteelcladSerpentEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "{this} can't attack unless you control another artifact";
    }

    private SteelcladSerpentEffect(SteelcladSerpentEffect effect) {
        super((RestrictionEffect)effect);
    }

    public SteelcladSerpentEffect copy() {
        return new SteelcladSerpentEffect(this);
    }

    public boolean canAttack(Game game, boolean canUseChooseDialogs) {
        return false;
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        if (permanent.getId().equals(source.getSourceId())) {
            return game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), source, game).isEmpty();
        }
        return false;
    }

    static {
        filter.add((Predicate)CardType.ARTIFACT.getPredicate());
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
    }
}

