/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.PermanentsOnTheBattlefieldCondition;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeSourceCost;
import mage.abilities.decorator.ConditionalOneShotEffect;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.abilities.effects.common.DoWhenCostPaid;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.abilities.triggers.BeginningOfEndStepTriggeredAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.permanent.token.RedHumanToken;
import mage.game.permanent.token.Token;
import mage.target.Target;
import mage.target.common.TargetAnyTarget;

public final class StensiaUprising
extends CardImpl {
    private static final Condition condition = new PermanentsOnTheBattlefieldCondition(StaticFilters.FILTER_PERMANENT, ComparisonType.EQUAL_TO, 13, true);
    private static final Hint hint = new ValueHint("Permanents you control", (DynamicValue)new PermanentsOnBattlefieldCount((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT));

    public StensiaUprising(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{2}{R}{R}");
        ReflexiveTriggeredAbility reflexiveTrigger = new ReflexiveTriggeredAbility((Effect)new DamageTargetEffect(7), false, "{this} deals 7 damage to any target");
        reflexiveTrigger.addTarget((Target)new TargetAnyTarget());
        BeginningOfEndStepTriggeredAbility ability = new BeginningOfEndStepTriggeredAbility((Effect)new CreateTokenEffect((Token)new RedHumanToken()));
        ability.addEffect((Effect)new ConditionalOneShotEffect((OneShotEffect)new DoWhenCostPaid(reflexiveTrigger, (Cost)new SacrificeSourceCost(), "Sacrifice {this}?"), condition, "Then if you control exactly thirteen permanents, you may sacrifice {this}. When you do, it deals 7 damage to any target."));
        this.addAbility(ability.addHint(hint));
    }

    private StensiaUprising(StensiaUprising card) {
        super((CardImpl)card);
    }

    public StensiaUprising copy() {
        return new StensiaUprising(this);
    }
}

