/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class StiltzkinMoogleMerchantEffect
extends OneShotEffect {
    StiltzkinMoogleMerchantEffect() {
        super(Outcome.Benefit);
        this.staticText = "Target opponent gains control of another target permanent you control. If they do, you draw a card.";
    }

    private StiltzkinMoogleMerchantEffect(StiltzkinMoogleMerchantEffect effect) {
        super((OneShotEffect)effect);
    }

    public StiltzkinMoogleMerchantEffect copy() {
        return new StiltzkinMoogleMerchantEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(((Target)source.getTargets().get(1)).getFirstTarget());
        if (permanent == null) {
            return false;
        }
        UUID opponent = this.getTargetPointer().getFirst(game, source);
        game.addEffect(new GainControlTargetEffect(Duration.Custom, true, opponent).setTargetPointer((TargetPointer)new FixedTarget(permanent.getId(), game)), source);
        game.processAction();
        if (permanent.isControlledBy(opponent)) {
            new DrawCardSourceControllerEffect(1).apply(game, source);
            return true;
        }
        return false;
    }
}

