/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.asthought.PlayFromNotOwnHandZoneTargetEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class StolenGoodsEffect
extends OneShotEffect {
    StolenGoodsEffect() {
        super(Outcome.Detriment);
        this.staticText = "Target opponent exiles cards from the top of their library until they exile a nonland card. Until end of turn, you may cast that card without paying its mana cost";
    }

    private StolenGoodsEffect(StolenGoodsEffect effect) {
        super((OneShotEffect)effect);
    }

    public StolenGoodsEffect copy() {
        return new StolenGoodsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (opponent == null) {
            return false;
        }
        while ((card = opponent.getLibrary().getFromTop(game)) != null) {
            if (card.isLand(game)) {
                if (!opponent.moveCardsToExile(card, source, game, true, source.getSourceId(), CardUtil.createObjectRelatedWindowTitle((Ability)source, (Game)game, null))) {
                    break;
                }
            } else {
                PlayFromNotOwnHandZoneTargetEffect.exileAndPlayFromExile((Game)game, (Ability)source, (Card)card, (TargetController)TargetController.YOU, (Duration)Duration.EndOfTurn, (boolean)true, (boolean)false, (boolean)true);
                break;
            }
            if (card.isLand(game)) continue;
        }
        return true;
    }
}

