/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.OneShotEffect;
import mage.cards.s.StolenUniformTriggeredAbility;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.SecondTargetPointer;
import mage.target.targetpointer.TargetPointer;

class StolenUniformTriggerEffect
extends OneShotEffect {
    StolenUniformTriggerEffect() {
        super(Outcome.Benefit);
        this.staticText = "When you lose control of that Equipment this turn, if it's attached to a creature you control, unattach it";
        this.setTargetPointer((TargetPointer)new SecondTargetPointer());
    }

    private StolenUniformTriggerEffect(StolenUniformTriggerEffect effect) {
        super((OneShotEffect)effect);
    }

    public StolenUniformTriggerEffect copy() {
        return new StolenUniformTriggerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new StolenUniformTriggeredAbility(permanent, game), source);
        return true;
    }
}

