/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Optional;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.cards.s.StolenUniformUnattachEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class StolenUniformTriggeredAbility
extends DelayedTriggeredAbility {
    private final MageObjectReference mor;
    private final int turnNum;

    StolenUniformTriggeredAbility(Permanent permanent, Game game) {
        super((Effect)new StolenUniformUnattachEffect(permanent, game), Duration.Custom, false, false);
        this.setTriggerPhrase("When you lose control of that Equipment this turn, ");
        this.mor = new MageObjectReference((MageObject)permanent, game);
        this.turnNum = game.getTurnNum();
    }

    private StolenUniformTriggeredAbility(StolenUniformTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
        this.mor = ability.mor;
        this.turnNum = ability.turnNum;
    }

    public StolenUniformTriggeredAbility copy() {
        return new StolenUniformTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.LOST_CONTROL;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (game.getTurnNum() > this.turnNum) {
            this.setDuration(Duration.EndOfTurn);
            return false;
        }
        return this.isControlledBy(event.getPlayerId()) && this.mor.zoneCounterIsCurrent(game) && event.getTargetId().equals(this.mor.getSourceId());
    }

    public boolean checkInterveningIfClause(Game game) {
        return Optional.ofNullable(this.mor.getPermanent(game)).map(Permanent::getAttachedTo).map(arg_0 -> ((Game)game).getControllerId(arg_0)).map(arg_0 -> ((StolenUniformTriggeredAbility)this).isControlledBy(arg_0)).orElse(false);
    }
}

