/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.DamageEvent;
import mage.game.events.GameEvent;
import mage.game.events.PreventDamageEvent;
import mage.game.events.PreventedDamageEvent;

class StonewiseFortifierPreventAllDamageToEffect
extends PreventionEffectImpl {
    StonewiseFortifierPreventAllDamageToEffect() {
        super(Duration.EndOfTurn);
        this.staticText = "Prevent all damage that would be dealt to {this} by target creature this turn";
    }

    private StonewiseFortifierPreventAllDamageToEffect(StonewiseFortifierPreventAllDamageToEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public StonewiseFortifierPreventAllDamageToEffect copy() {
        return new StonewiseFortifierPreventAllDamageToEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        PreventDamageEvent preventEvent = new PreventDamageEvent(event.getTargetId(), event.getSourceId(), source, source.getControllerId(), event.getAmount(), ((DamageEvent)event).isCombatDamage());
        if (!game.replaceEvent((GameEvent)preventEvent)) {
            int preventedDamage = event.getAmount();
            MageObject damageSource = game.getObject(event.getSourceId());
            MageObject preventionSource = game.getObject(source);
            if (damageSource != null && preventionSource != null) {
                String message = " damage from " + damageSource.getName() + " prevented " + '(' + preventionSource + ')';
                game.informPlayers(message);
            }
            event.setAmount(0);
            game.fireEvent((GameEvent)new PreventedDamageEvent(event.getTargetId(), source.getSourceId(), source, source.getControllerId(), preventedDamage));
        }
        return false;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (super.applies(event, source, game) && event.getTargetId().equals(source.getSourceId())) {
            return event.getSourceId().equals(this.getTargetPointer().getFirst(game, source));
        }
        return false;
    }
}

