/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.DiscardCardCost;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;

class StormscaleAnarchEffect
extends OneShotEffect {
    StormscaleAnarchEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} deals 2 damage to any target. If the discarded card was multicolored, {this} deals 4 damage instead.";
    }

    private StormscaleAnarchEffect(StormscaleAnarchEffect effect) {
        super((OneShotEffect)effect);
    }

    public StormscaleAnarchEffect copy() {
        return new StormscaleAnarchEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int damageToDeal = 2;
        block0: for (Cost cost : source.getCosts()) {
            if (!(cost instanceof DiscardCardCost)) continue;
            for (Card card : ((DiscardCardCost)cost).getCards()) {
                if (!card.getColor(game).isMulticolored()) continue;
                damageToDeal = 4;
                break block0;
            }
        }
        return new DamageTargetEffect(damageToDeal).apply(game, source);
    }
}

