/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.s.StoryweaveWatcher;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class StoryweaveReplacementEffect
extends ReplacementEffectImpl {
    private int counter = 0;

    StoryweaveReplacementEffect() {
        super(Duration.EndOfTurn, Outcome.BoostCreature);
        this.staticText = "The next time one or more enchantment creatures you control enter this turn, each enters with two additional +1/+1 counters on it";
    }

    private StoryweaveReplacementEffect(StoryweaveReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
        this.counter = effect.counter;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        this.counter = StoryweaveWatcher.getCounter(game, source);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (StoryweaveWatcher.getCounter(game, source) > this.counter) {
            this.discard();
            return false;
        }
        Permanent permanent = ((EntersTheBattlefieldEvent)event).getTarget();
        return permanent != null && permanent.isControlledBy(source.getControllerId()) && permanent.isEnchantment(game) && permanent.isCreature(game);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent creature = ((EntersTheBattlefieldEvent)event).getTarget();
        if (creature != null) {
            creature.addCounters(CounterType.P1P1.createInstance(2), source.getControllerId(), source, game, event.getAppliedEffects());
        }
        return false;
    }

    public StoryweaveReplacementEffect copy() {
        return new StoryweaveReplacementEffect(this);
    }
}

