/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Arrays;
import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.SacrificeSourceEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.abilities.triggers.BeginningOfEndStepTriggeredAbility;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Controllable;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class StragoAndRelmEffect
extends OneShotEffect {
    StragoAndRelmEffect() {
        super(Outcome.Benefit);
        this.staticText = "target opponent exiles cards from the top of their library until they exile an instant, sorcery, or creature card. You may cast that card without paying its mana cost. If you cast a creature spell this way, it gains haste and \"At the beginning of the end step, sacrifice this creature.\"";
    }

    private StragoAndRelmEffect(StragoAndRelmEffect effect) {
        super((OneShotEffect)effect);
    }

    public StragoAndRelmEffect copy() {
        return new StragoAndRelmEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (opponent == null) {
            return false;
        }
        Card card = StragoAndRelmEffect.getCard(opponent, game, source);
        if (card == null) {
            return false;
        }
        Optional.ofNullable(source).map(Controllable::getControllerId).map(arg_0 -> ((Game)game).getPlayer(arg_0)).ifPresent(player -> CardUtil.castSpellWithAttributesForFree((Player)player, (Ability)source, (Game)game, (Cards)new CardsImpl(card), (FilterCard)StaticFilters.FILTER_CARD, (CardUtil.SpellCastTracker)StragoAndRelmTracker.instance));
        return true;
    }

    private static Card getCard(Player player, Game game, Ability source) {
        for (Card card : player.getLibrary().getCards(game)) {
            player.moveCards(card, Zone.EXILED, source, game);
            if (!card.isInstantOrSorcery(game) && !card.isCreature(game)) continue;
            return card;
        }
        return null;
    }

    private static enum StragoAndRelmTracker implements CardUtil.SpellCastTracker
    {
        instance;


        public boolean checkCard(Card card, Game game) {
            return true;
        }

        public void addCard(Card card, Ability source, Game game) {
            if (!card.isCreature(game)) {
                return;
            }
            for (ContinuousEffect continuousEffect : Arrays.asList(new GainAbilityTargetEffect((Ability)HasteAbility.getInstance()), new GainAbilityTargetEffect((Ability)new BeginningOfEndStepTriggeredAbility((Effect)new SacrificeSourceEffect())))) {
                continuousEffect.setTargetPointer((TargetPointer)new FixedTarget(card.getId()));
                game.getState().addEffect(continuousEffect, (Ability)card.getSpellAbility());
                game.addEffect(continuousEffect, source);
            }
        }
    }
}

