/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.common.FilterLandCard;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class StrataScytheImprintEffect
extends OneShotEffect {
    StrataScytheImprintEffect() {
        super(Outcome.Exile);
        this.staticText = "search your library for a land card, exile it, then shuffle";
    }

    private StrataScytheImprintEffect(StrataScytheImprintEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInLibrary target = new TargetCardInLibrary((FilterCard)new FilterLandCard());
        if (player.searchLibrary(target, source, game) && !target.getTargets().isEmpty()) {
            UUID cardId = (UUID)target.getTargets().get(0);
            Card card = player.getLibrary().remove(cardId, game);
            if (card != null) {
                card.moveToExile(source.getSourceId(), "Strata Scythe", source, game);
                Permanent permanent = game.getPermanent(source.getSourceId());
                if (permanent != null) {
                    permanent.imprint(card.getId(), game);
                }
            }
        }
        player.shuffleLibrary(source, game);
        return true;
    }

    public StrataScytheImprintEffect copy() {
        return new StrataScytheImprintEffect(this);
    }
}

