/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledCreaturePermanent;

class StrategicBetrayalEffect
extends OneShotEffect {
    StrategicBetrayalEffect() {
        super(Outcome.Benefit);
        this.staticText = "target opponent exiles a creature they control and their graveyard";
    }

    private StrategicBetrayalEffect(StrategicBetrayalEffect effect) {
        super((OneShotEffect)effect);
    }

    public StrategicBetrayalEffect copy() {
        return new StrategicBetrayalEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl((Collection)player.getGraveyard());
        if (game.getBattlefield().contains((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, player.getId(), source, game, 1)) {
            TargetControlledCreaturePermanent target = new TargetControlledCreaturePermanent();
            target.withNotTarget(true);
            player.choose(Outcome.DestroyPermanent, (Target)target, source, game);
            cards.add((Object)target.getFirstTarget());
        }
        return player.moveCards((Cards)cards, Zone.EXILED, source, game);
    }
}

