/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class StrengthOfTheTajuruAddCountersTargetEffect
extends OneShotEffect {
    StrengthOfTheTajuruAddCountersTargetEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "Choose target creature, then choose another target creature for each time this spell was kicked. Put X +1/+1 counters on each of them";
    }

    private StrengthOfTheTajuruAddCountersTargetEffect(StrengthOfTheTajuruAddCountersTargetEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        int affectedTargets = 0;
        int amount = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        Counter counter = CounterType.P1P1.createInstance(amount);
        for (UUID uuid : this.getTargetPointer().getTargets(game, source)) {
            Permanent permanent = game.getPermanent(uuid);
            if (permanent == null) continue;
            permanent.addCounters(counter.copy(), source.getControllerId(), source, game);
            ++affectedTargets;
        }
        return affectedTargets > 0;
    }

    public StrengthOfTheTajuruAddCountersTargetEffect copy() {
        return new StrengthOfTheTajuruAddCountersTargetEffect(this);
    }
}

