/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Map;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.CreateTokenEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.token.ThopterColorlessToken;
import mage.game.permanent.token.Token;

class StridehangarAutomatonReplacementEffect
extends ReplacementEffectImpl {
    StridehangarAutomatonReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If one or more artifact tokens would be created under your control, those tokens plus an additional 1/1 colorless Thopter artifact creature token with flying are created instead";
    }

    private StridehangarAutomatonReplacementEffect(StridehangarAutomatonReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public StridehangarAutomatonReplacementEffect copy() {
        return new StridehangarAutomatonReplacementEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CREATE_TOKEN;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (source.isControlledBy(event.getPlayerId())) {
            for (Map.Entry entry : ((CreateTokenEvent)event).getTokens().entrySet()) {
                if ((Integer)entry.getValue() <= 0 || !((Token)entry.getKey()).isArtifact(game)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        if (event instanceof CreateTokenEvent) {
            CreateTokenEvent tokenEvent = (CreateTokenEvent)event;
            ThopterColorlessToken thopterToken = null;
            Map tokens = tokenEvent.getTokens();
            for (Map.Entry entry : tokens.entrySet()) {
                if (!(entry.getKey() instanceof ThopterColorlessToken)) continue;
                thopterToken = (ThopterColorlessToken)entry.getKey();
            }
            if (thopterToken == null) {
                thopterToken = new ThopterColorlessToken();
            }
            tokens.put(thopterToken, tokens.getOrDefault(thopterToken, 0) + 1);
        }
        return false;
    }
}

