/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class StrixhavenStadiumEffect
extends OneShotEffect {
    StrixhavenStadiumEffect() {
        super(Outcome.Benefit);
        this.staticText = "Then if it has ten or more point counters on it, remove them all and that player loses the game";
    }

    private StrixhavenStadiumEffect(StrixhavenStadiumEffect effect) {
        super((OneShotEffect)effect);
    }

    public StrixhavenStadiumEffect copy() {
        return new StrixhavenStadiumEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player;
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        boolean lki = false;
        if (permanent == null) {
            lki = true;
            permanent = source.getSourcePermanentOrLKI(game);
        }
        if (permanent == null || permanent.getCounters(game).getCount(CounterType.POINT) < 10) {
            return false;
        }
        if (!lki) {
            permanent.removeCounters(CounterType.POINT.createInstance(permanent.getCounters(game).getCount(CounterType.POINT)), source, game);
        }
        if ((player = game.getPlayer(this.getTargetPointer().getFirst(game, source))) != null) {
            player.lost(game);
            return true;
        }
        return !lki;
    }
}

