/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.LinkedHashMap;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;

class StrongholdGambitEffect
extends OneShotEffect {
    StrongholdGambitEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Each player chooses a card in their hand. Then each player reveals their chosen card. The owner of each creature card revealed this way with the lowest mana value puts it onto the battlefield";
    }

    private StrongholdGambitEffect(StrongholdGambitEffect effect) {
        super((OneShotEffect)effect);
    }

    public StrongholdGambitEffect copy() {
        return new StrongholdGambitEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (controller != null && sourceObject != null) {
            LinkedHashMap<Object, UUID> chosenCards = new LinkedHashMap<Object, UUID>();
            for (Object playerId : game.getState().getPlayerList(controller.getId())) {
                TargetCardInHand target;
                Player player = game.getPlayer((UUID)playerId);
                if (player == null || player.getHand().isEmpty() || !player.choose(Outcome.Benefit, (Target)(target = new TargetCardInHand()), source, game)) continue;
                chosenCards.put(playerId, target.getFirstTarget());
            }
            int lowestCMC = Integer.MAX_VALUE;
            for (UUID playerId : game.getState().getPlayerList(controller.getId())) {
                Card card;
                Player player = game.getPlayer(playerId);
                if (player == null || !chosenCards.containsKey(playerId) || (card = game.getCard((UUID)chosenCards.get(playerId))) == null) continue;
                CardsImpl cardsToReveal = new CardsImpl(card);
                player.revealCards(sourceObject.getIdName() + " (" + player.getName() + ')', (Cards)cardsToReveal, game);
                if (!card.isCreature(game) || lowestCMC <= card.getManaValue()) continue;
                lowestCMC = card.getManaValue();
            }
            if (lowestCMC < Integer.MAX_VALUE) {
                CardsImpl creaturesToBattlefield = new CardsImpl();
                for (UUID playerId : game.getState().getPlayerList(controller.getId())) {
                    Card card;
                    Player player = game.getPlayer(playerId);
                    if (player == null || !chosenCards.containsKey(playerId) || (card = game.getCard((UUID)chosenCards.get(playerId))) == null || !card.isCreature(game) || lowestCMC != card.getManaValue()) continue;
                    creaturesToBattlefield.add(card);
                }
                controller.moveCards(creaturesToBattlefield.getCards(game), Zone.BATTLEFIELD, source, game, false, false, true, null);
            }
            return true;
        }
        return false;
    }
}

