/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.watchers.Watcher;

class StructuralAssaultWatcher
extends Watcher {
    private int artifactsDied = 0;

    public StructuralAssaultWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        ZoneChangeEvent zEvent;
        if (event.getType() == GameEvent.EventType.ZONE_CHANGE && (zEvent = (ZoneChangeEvent)event).isDiesEvent() && zEvent.getTarget().isArtifact(game)) {
            ++this.artifactsDied;
        }
    }

    public void reset() {
        super.reset();
        this.artifactsDied = 0;
    }

    public int getArtifactsDied() {
        return this.artifactsDied;
    }
}

