/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class StruggleForProjectRadCountersTriggeredAbility
extends TriggeredAbilityImpl {
    public StruggleForProjectRadCountersTriggeredAbility() {
        super(Zone.BATTLEFIELD, null);
    }

    private StruggleForProjectRadCountersTriggeredAbility(StruggleForProjectRadCountersTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public StruggleForProjectRadCountersTriggeredAbility copy() {
        return new StruggleForProjectRadCountersTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARED_ATTACKERS;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Player attackingPlayer = game.getPlayer(event.getPlayerId());
        if (attackingPlayer == null) {
            return false;
        }
        Set attackersOnYou = game.getCombat().getGroups().stream().filter(g -> Objects.equals(g.getDefenderId(), this.getControllerId())).flatMap(g -> g.getAttackers().stream()).collect(Collectors.toSet());
        if (attackersOnYou.isEmpty()) {
            return false;
        }
        this.getEffects().clear();
        AddCountersTargetEffect effect = new AddCountersTargetEffect(CounterType.RAD.createInstance(), (DynamicValue)StaticValue.get((int)(attackersOnYou.size() * 2)));
        effect.setTargetPointer((TargetPointer)new FixedTarget(attackingPlayer.getId()));
        this.getEffects().add((Object)effect);
        return true;
    }

    public String getRule() {
        return "Whenever a player attacks you with one or more creatures, that player gets twice that many rad counters.";
    }
}

