/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class StruggleForSanityEffect
extends OneShotEffect {
    StruggleForSanityEffect() {
        super(Outcome.Discard);
        this.staticText = "Target opponent reveals their hand. That player exiles a card from it, then you exile a card from it. Repeat this process until all cards in that hand have been exiled. That player returns the cards they exiled this way to their hand and puts the rest into their graveyard";
    }

    private StruggleForSanityEffect(StruggleForSanityEffect effect) {
        super((OneShotEffect)effect);
    }

    public StruggleForSanityEffect copy() {
        return new StruggleForSanityEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        MageObject sourceObject = source.getSourceObject(game);
        Player controller = game.getPlayer(source.getControllerId());
        if (targetPlayer == null || sourceObject == null || controller == null) {
            return false;
        }
        targetPlayer.revealCards(sourceObject.getIdName(), targetPlayer.getHand(), game);
        CardsImpl cardsLeft = new CardsImpl((Collection)targetPlayer.getHand());
        CardsImpl exiledByController = new CardsImpl();
        UUID exileZoneController = UUID.randomUUID();
        CardsImpl exiledByOpponent = new CardsImpl();
        UUID exileZoneOpponent = UUID.randomUUID();
        boolean opponentsChoice = true;
        TargetCard target = new TargetCard(Zone.HAND, new FilterCard("a card to exile"));
        while (!cardsLeft.isEmpty()) {
            Card card;
            if (opponentsChoice) {
                targetPlayer.choose(Outcome.ReturnToHand, (Cards)cardsLeft, target, source, game);
                card = game.getCard(target.getFirstTarget());
                if (card != null) {
                    exiledByOpponent.add(card);
                    cardsLeft.remove(card);
                    targetPlayer.moveCardsToExile(card, source, game, true, exileZoneOpponent, sourceObject.getIdName() + " exiled by " + targetPlayer.getName());
                }
            } else {
                controller.choose(Outcome.Discard, (Cards)cardsLeft, target, source, game);
                card = game.getCard(target.getFirstTarget());
                if (card != null) {
                    exiledByController.add(card);
                    cardsLeft.remove(card);
                    controller.moveCardsToExile(card, source, game, true, exileZoneController, sourceObject.getIdName() + " exiled by " + controller.getName());
                }
            }
            target.clearChosen();
            opponentsChoice = !opponentsChoice;
        }
        targetPlayer.moveCards((Cards)exiledByOpponent, Zone.HAND, source, game);
        targetPlayer.moveCards((Cards)exiledByController, Zone.GRAVEYARD, source, game);
        return true;
    }
}

