/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.keyword.ScryEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.players.ManaPoolItem;
import mage.players.Player;
import mage.watchers.common.CommanderPlaysCountWatcher;

class StudyHallTriggeredAbility
extends DelayedTriggeredAbility {
    StudyHallTriggeredAbility() {
        super(null, Duration.Custom, true, false);
    }

    private StudyHallTriggeredAbility(StudyHallTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public StudyHallTriggeredAbility copy() {
        return new StudyHallTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.MANA_PAID;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        block6: {
            block5: {
                if (!this.getSourceId().equals(event.getSourceId())) {
                    return false;
                }
                Permanent sourcePermanent = this.getSourcePermanentOrLKI(game);
                if (sourcePermanent == null) break block5;
                if (!sourcePermanent.getAbilities(game).stream().map(Ability::getOriginalId).map(UUID::toString).noneMatch(event.getData()::equals)) break block6;
            }
            return false;
        }
        Player player = game.getPlayer(this.getControllerId());
        Spell spell = game.getStack().getSpell(event.getTargetId());
        CommanderPlaysCountWatcher watcher = (CommanderPlaysCountWatcher)game.getState().getWatcher(CommanderPlaysCountWatcher.class);
        if (player == null || spell == null || watcher == null || !game.isCommanderObject(player, (MageObject)spell)) {
            return false;
        }
        this.getEffects().clear();
        this.addEffect((Effect)new ScryEffect(watcher.getPlaysCount(spell.getMainCard().getId())));
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isInactive(Game game) {
        if (super.isInactive(game)) {
            return true;
        }
        Player player = game.getPlayer(this.getControllerId());
        if (player == null) return true;
        if (!player.getManaPool().getManaItems().stream().map(ManaPoolItem::getSourceId).noneMatch(this.getSourceId()::equals)) return false;
        return true;
    }

    public String getRule() {
        return "When you spend this mana to cast your commander, scry X, where X is the number of times it's been cast from the command zone this game.";
    }
}

