/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ExileReturnBattlefieldNextEndStepTargetEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class SuddenDisappearanceEffect
extends OneShotEffect {
    SuddenDisappearanceEffect() {
        super(Outcome.Exile);
        this.staticText = "Exile all nonland permanents target player controls. Return the exiled cards to the battlefield under their owner's control at the beginning of the next end step";
    }

    private SuddenDisappearanceEffect(SuddenDisappearanceEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getFirstTarget());
        if (player == null) {
            return false;
        }
        CardsImpl targets = new CardsImpl(game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENTS_NON_LAND, player.getId(), game));
        if (targets.isEmpty()) {
            return false;
        }
        ExileReturnBattlefieldNextEndStepTargetEffect effect = new ExileReturnBattlefieldNextEndStepTargetEffect().returnExiledOnly(true);
        effect.setTargetPointer((TargetPointer)new FixedTargets((Cards)targets, game));
        return effect.apply(game, source);
    }

    public SuddenDisappearanceEffect copy() {
        return new SuddenDisappearanceEffect(this);
    }
}

