/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.constants.WatcherScope;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class SummonBrynhildrWatcher
extends Watcher {
    private final Map<MageObjectReference, Set<UUID>> map = new HashMap<MageObjectReference, Set<UUID>>();

    SummonBrynhildrWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.COUNTER_ADDED || !CounterType.STUN.getName().equals(event.getData())) {
            return;
        }
        Permanent permanent = game.getPermanent(event.getTargetId());
        if (permanent != null) {
            this.map.computeIfAbsent(new MageObjectReference((MageObject)permanent, game), x -> new HashSet()).add(event.getPlayerId());
        }
    }

    public void reset() {
        super.reset();
        this.map.clear();
    }

    static boolean check(Game game, Ability source) {
        return ((SummonBrynhildrWatcher)game.getState().getWatcher(SummonBrynhildrWatcher.class)).map.getOrDefault(new MageObjectReference(source.getSourceId(), source.getStackMomentSourceZCC(), game), Collections.emptySet()).contains(source.getControllerId());
    }
}

