/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.TokenPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class SummonGoodKingMogXIIEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledPermanent("non-Saga token you control");

    SummonGoodKingMogXIIEffect() {
        super(Outcome.Benefit);
        this.staticText = "create a token that's a copy of a non-Saga token you control";
    }

    private SummonGoodKingMogXIIEffect(SummonGoodKingMogXIIEffect effect) {
        super((OneShotEffect)effect);
    }

    public SummonGoodKingMogXIIEffect copy() {
        return new SummonGoodKingMogXIIEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || !game.getBattlefield().contains(filter, source, game, 1)) {
            return false;
        }
        TargetPermanent target = new TargetPermanent(filter);
        target.withNotTarget(true);
        player.choose(this.outcome, (Target)target, source, game);
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        return permanent != null && new CreateTokenCopyTargetEffect().setSavedPermanent(permanent).apply(game, source);
    }

    static {
        filter.add(Predicates.not((Predicate)SubType.SAGA.getPredicate()));
        filter.add((Predicate)TokenPredicate.TRUE);
    }
}

