/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

class SummonUndeadEffect
extends OneShotEffect {
    SummonUndeadEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may mill three cards. Then return a creature card from your graveyard to the battlefield";
    }

    private SummonUndeadEffect(SummonUndeadEffect effect) {
        super((OneShotEffect)effect);
    }

    public SummonUndeadEffect copy() {
        return new SummonUndeadEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        if (player.chooseUse(this.outcome, "Mill three cards?", source, game)) {
            player.millCards(3, source, game);
        }
        if (player.getGraveyard().count((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game) < 1) {
            return true;
        }
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard((FilterCard)StaticFilters.FILTER_CARD_CREATURE);
        target.withNotTarget(true);
        player.choose(this.outcome, (Target)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        player.moveCards(card, Zone.BATTLEFIELD, source, game);
        return true;
    }
}

