/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInHand;

class SummonersGrimoireEffect
extends OneShotEffect {
    SummonersGrimoireEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may put a creature card from your hand onto the battlefield. If that card is an enchantment card, it enters tapped and attacking";
    }

    private SummonersGrimoireEffect(SummonersGrimoireEffect effect) {
        super((OneShotEffect)effect);
    }

    public SummonersGrimoireEffect copy() {
        return new SummonersGrimoireEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInHand target = new TargetCardInHand(0, 1, (FilterCard)StaticFilters.FILTER_CARD_CREATURE);
        player.choose(this.outcome, player.getHand(), (TargetCard)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card == null) {
            return false;
        }
        boolean flag = card.isEnchantment(game);
        player.moveCards(card, Zone.BATTLEFIELD, source, game, flag, false, false, null);
        if (flag) {
            game.getCombat().addAttackingCreature(card.getId(), game);
        }
        return true;
    }
}

