/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SunClaspReturnEffect
extends OneShotEffect {
    SunClaspReturnEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "Return enchanted creature to its owner's hand";
    }

    public SunClaspReturnEffect(SunClaspReturnEffect effect) {
        super((OneShotEffect)effect);
    }

    public SunClaspReturnEffect copy() {
        return new SunClaspReturnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && permanent != null && permanent.getAttachedTo() != null) {
            Permanent enchantedCreature = game.getPermanent(permanent.getAttachedTo());
            if (enchantedCreature != null) {
                controller.moveCards((Card)enchantedCreature, Zone.HAND, source, game);
            }
            return true;
        }
        return false;
    }
}

