/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageSelfEffect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;

class SunflareShamanEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("Elemental");

    public SunflareShamanEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals X damage to any target and X damage to itself, where X is the number of Elemental cards in your graveyard";
    }

    private SunflareShamanEffect(SunflareShamanEffect effect) {
        super((OneShotEffect)effect);
    }

    public SunflareShamanEffect copy() {
        return new SunflareShamanEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            int ElementalsInYourGraveyard = controller.getGraveyard().count(filter, game);
            new DamageTargetEffect(ElementalsInYourGraveyard).apply(game, source);
            new DamageSelfEffect(ElementalsInYourGraveyard).apply(game, source);
            return true;
        }
        return false;
    }

    static {
        filter.add((Predicate)SubType.ELEMENTAL.getPredicate());
    }
}

