/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.ApprovingObject;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.s.CardCanBeCastPredicate;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class SunforgerEffect
extends OneShotEffect {
    SunforgerEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "Search your library for a red or white instant card with mana value 4 or less and cast that card without paying its mana cost. Then shuffle";
    }

    private SunforgerEffect(SunforgerEffect effect) {
        super((OneShotEffect)effect);
    }

    public SunforgerEffect copy() {
        return new SunforgerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            if (controller.getLibrary().hasCards()) {
                UUID targetId;
                Card card;
                FilterCard filter = new FilterCard("red or white instant card with mana value 4 or less");
                TargetCardInLibrary target = new TargetCardInLibrary(filter);
                filter.add(Predicates.or((Predicate)new ColorPredicate(ObjectColor.RED), (Predicate)new ColorPredicate(ObjectColor.WHITE)));
                filter.add((Predicate)CardType.INSTANT.getPredicate());
                filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, 5));
                filter.add((Predicate)new CardCanBeCastPredicate(source.getControllerId()));
                if (controller.searchLibrary(target, source, game, controller.getId()) && (card = game.getCard(targetId = target.getFirstTarget())) != null) {
                    game.getState().setValue("PlayFromNotOwnHandZone" + card.getId(), (Object)Boolean.TRUE);
                    controller.cast(controller.chooseAbilityForCast(card, game, true), game, true, new ApprovingObject(source, game));
                    game.getState().setValue("PlayFromNotOwnHandZone" + card.getId(), null);
                }
            }
            controller.shuffleLibrary(source, game);
            return true;
        }
        return false;
    }
}

