/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.game.Game;
import mage.game.permanent.Permanent;

class SunforgerUnattachCost
extends CostImpl {
    public SunforgerUnattachCost() {
        this.text = "Unattach {this}";
    }

    private SunforgerUnattachCost(SunforgerUnattachCost cost) {
        super((CostImpl)cost);
    }

    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        Permanent attachedTo;
        Permanent attachment = game.getPermanent(source.getSourceId());
        if (attachment != null && attachment.getAttachedTo() != null && (attachedTo = game.getPermanent(attachment.getAttachedTo())) != null) {
            this.paid = attachedTo.removeAttachment(attachment.getId(), source, game);
        }
        return this.paid;
    }

    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        Permanent attachedTo;
        Permanent attachment = game.getPermanent(source.getSourceId());
        return attachment != null && attachment.getAttachedTo() != null && (attachedTo = game.getPermanent(attachment.getAttachedTo())) != null;
    }

    public SunforgerUnattachCost copy() {
        return new SunforgerUnattachCost(this);
    }
}

