/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.combat.CantBeBlockedByAllSourceEffect;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.keyword.HexproofBaseAbility;
import mage.choices.Choice;
import mage.choices.ChoiceColor;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.players.Player;

class SungoldSentinelEffect
extends OneShotEffect {
    SungoldSentinelEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose a color. {this} gains hexproof from that color until end of turn and can't be blocked by creatures of that color this turn";
    }

    private SungoldSentinelEffect(SungoldSentinelEffect effect) {
        super((OneShotEffect)effect);
    }

    public SungoldSentinelEffect copy() {
        return new SungoldSentinelEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        ChoiceColor choice = new ChoiceColor(true);
        player.choose(this.outcome, (Choice)choice, game);
        HexproofBaseAbility ability = HexproofBaseAbility.getFirstFromColor((ObjectColor)choice.getColor());
        game.addEffect((ContinuousEffect)new GainAbilitySourceEffect((Ability)ability, Duration.EndOfTurn), source);
        FilterCreaturePermanent filter = new FilterCreaturePermanent();
        filter.add((Predicate)new ColorPredicate(choice.getColor()));
        game.addEffect((ContinuousEffect)new CantBeBlockedByAllSourceEffect(filter, Duration.EndOfTurn), source);
        return true;
    }
}

