/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetImpl;
import mage.target.common.TargetControlledCreaturePermanent;

class SunkenHopeReturnToHandEffect
extends OneShotEffect {
    SunkenHopeReturnToHandEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "that player returns a creature they control to its owner's hand";
    }

    private SunkenHopeReturnToHandEffect(SunkenHopeReturnToHandEffect effect) {
        super((OneShotEffect)effect);
    }

    public SunkenHopeReturnToHandEffect copy() {
        return new SunkenHopeReturnToHandEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        boolean result = false;
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player == null) {
            return false;
        }
        TargetImpl target = new TargetControlledCreaturePermanent().withNotTarget(true);
        if (target.canChoose(player.getId(), source, game)) {
            while (player.canRespond() && !target.isChosen(game) && target.canChoose(player.getId(), source, game)) {
                player.chooseTarget(Outcome.ReturnToHand, (Target)target, source, game);
            }
            for (UUID targetId : target.getTargets()) {
                Permanent permanent = game.getPermanent(targetId);
                if (permanent == null) continue;
                result |= player.moveCards((Card)permanent, Zone.HAND, source, game);
            }
        }
        return result;
    }
}

