/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Controllable;
import mage.game.Game;
import mage.game.permanent.token.HumanToken;
import mage.players.Player;

class SunsetRevelryEffect
extends OneShotEffect {
    SunsetRevelryEffect() {
        super(Outcome.Benefit);
        this.staticText = "If an opponent has more life than you, you gain 4 life.<br>If an opponent controls more creatures than you, create two 1/1 white Human creature tokens.<br>If an opponent has more cards in hand than you, draw a card.";
    }

    private SunsetRevelryEffect(SunsetRevelryEffect effect) {
        super((OneShotEffect)effect);
    }

    public SunsetRevelryEffect copy() {
        return new SunsetRevelryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Map map;
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Set opponents = game.getOpponents(source.getControllerId());
        if (opponents.stream().map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(Objects::nonNull).mapToInt(Player::getLife).anyMatch(x -> x > player.getLife())) {
            player.gainLife(4, game, source);
        }
        if ((map = game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), game).stream().filter(Objects::nonNull).map(Controllable::getControllerId).filter(uuid -> opponents.contains(uuid) || source.getControllerId().equals(uuid)).collect(Collectors.toMap(Function.identity(), x -> 1, Integer::sum))).getOrDefault(source.getControllerId(), 0) < map.values().stream().mapToInt(x -> x).max().orElse(0)) {
            new HumanToken().putOntoBattlefield(2, game, source, source.getControllerId());
        }
        if (opponents.stream().map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(Objects::nonNull).map(Player::getHand).mapToInt(Set::size).anyMatch(x -> x > player.getHand().size())) {
            player.drawCards(1, source, game);
        }
        return true;
    }
}

