/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Optional;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.SavedDamageValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class SuperStateEffect
extends OneShotEffect {
    SuperStateEffect() {
        super(Outcome.Benefit);
        this.staticText = "it deals that much damage to each other opponent";
    }

    private SuperStateEffect(SuperStateEffect effect) {
        super((OneShotEffect)effect);
    }

    public SuperStateEffect copy() {
        return new SuperStateEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        UUID permanentId = Optional.ofNullable(source.getSourcePermanentOrLKI(game)).map(Permanent::getAttachedTo).orElse(null);
        int damage = SavedDamageValue.MUCH.calculate(game, source, (Effect)this);
        if (permanentId == null || damage < 1) {
            return false;
        }
        UUID playerId = this.getTargetPointer().getFirst(game, source);
        for (UUID opponentId : game.getOpponents(source.getControllerId())) {
            Optional.ofNullable(opponentId).filter(uuid -> !uuid.equals(playerId)).map(arg_0 -> ((Game)game).getPlayer(arg_0)).ifPresent(player -> player.damage(damage, permanentId, source, game));
        }
        return true;
    }
}

