/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.PermanentsOnTheBattlefieldCondition;
import mage.abilities.decorator.ConditionalContinuousEffect;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.CastSourceTriggeredAbility;
import mage.abilities.effects.common.TapTargetEffect;
import mage.abilities.effects.common.continuous.BoostEnchantedEffect;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.hint.ConditionHint;
import mage.abilities.hint.Hint;
import mage.abilities.keyword.EnchantAbility;
import mage.abilities.keyword.FlashAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterControlledPermanent;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.common.TargetControlledCreaturePermanent;

public final class SupernaturalRescue
extends CardImpl {
    private static final FilterPermanent filter = new FilterControlledPermanent(SubType.SPIRIT);
    private static final Condition condition = new PermanentsOnTheBattlefieldCondition(filter);
    private static final Hint hint = new ConditionHint(condition, "You control a Spirit");

    public SupernaturalRescue(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{3}{W}");
        this.subtype.add((Object)SubType.AURA);
        this.addAbility(new SimpleStaticAbility(Zone.ALL, (Effect)new ConditionalContinuousEffect((ContinuousEffect)new GainAbilitySourceEffect((Ability)FlashAbility.getInstance(), Duration.WhileOnBattlefield, true), condition, "this spell has flash as long as you control a Spirit")).setRuleAtTheTop(true).addHint(hint));
        CastSourceTriggeredAbility ability = new CastSourceTriggeredAbility((Effect)new TapTargetEffect().setText("tap up to two target creatures you don't control"));
        ability.addTarget((Target)new TargetPermanent(0, 2, (FilterPermanent)StaticFilters.FILTER_CREATURE_YOU_DONT_CONTROL));
        this.addAbility((Ability)ability);
        TargetControlledCreaturePermanent auraTarget = new TargetControlledCreaturePermanent();
        this.getSpellAbility().addTarget((Target)auraTarget);
        this.getSpellAbility().addEffect((Effect)new AttachEffect(Outcome.BoostCreature));
        this.addAbility((Ability)new EnchantAbility((Target)auraTarget));
        this.addAbility((Ability)new SimpleStaticAbility((Effect)new BoostEnchantedEffect(1, 2)));
    }

    private SupernaturalRescue(SupernaturalRescue card) {
        super((CardImpl)card);
    }

    public SupernaturalRescue copy() {
        return new SupernaturalRescue(this);
    }
}

