/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfPlayersNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnFromExileEffect;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class SuppressEffect
extends OneShotEffect {
    SuppressEffect() {
        super(Outcome.Detriment);
        this.staticText = "target player exiles all cards from their hand face down. At the beginning of the end step of that player's next turn, that player returns those cards to their hand";
    }

    private SuppressEffect(SuppressEffect effect) {
        super((OneShotEffect)effect);
    }

    public SuppressEffect copy() {
        return new SuppressEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player == null || player.getHand().isEmpty()) {
            return false;
        }
        CardsImpl cards = new CardsImpl((Collection)player.getHand());
        player.moveCardsToExile(cards.getCards(game), source, game, false, CardUtil.getExileZoneId((Game)game, (Ability)source), CardUtil.getSourceName((Game)game, (Ability)source));
        cards.getCards(game).stream().filter(card -> game.getState().getZone(card.getId()) == Zone.EXILED).forEach(card -> card.setFaceDown(true, game));
        DelayedTriggeredAbility ability = new AtTheBeginOfPlayersNextEndStepDelayedTriggeredAbility((Effect)new ReturnFromExileEffect(Zone.HAND).setText("that player returns those cards to their hand"), player.getId()).setTriggerPhrase("At the beginning of the end step of that player's next turn, ");
        game.addDelayedTriggeredAbility(ability, source);
        return true;
    }
}

