/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.s.OpponentNoncombatLostLifeCount;
import mage.constants.Outcome;
import mage.counters.Counter;
import mage.game.Game;
import mage.game.permanent.Permanent;

class SupremeLeaderSnokeCounterEffect
extends OneShotEffect {
    protected final Counter counter;

    public SupremeLeaderSnokeCounterEffect(Counter counter) {
        super(Outcome.Benefit);
        this.counter = counter;
        this.staticText = "Put a loyalty counter on {this} for each life lost by all opponents from noncombat sources this turn";
    }

    private SupremeLeaderSnokeCounterEffect(SupremeLeaderSnokeCounterEffect effect) {
        super((OneShotEffect)effect);
        this.counter = effect.counter.copy();
    }

    public boolean apply(Game game, Ability source) {
        int amount;
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent != null && (amount = OpponentNoncombatLostLifeCount.instance.calculate(game, source, (Effect)this)) > 0) {
            Counter counterToAdd = this.counter.copy();
            counterToAdd.add(amount - this.counter.getCount());
            permanent.addCounters(counterToAdd, source.getControllerId(), source, game);
        }
        return true;
    }

    public SupremeLeaderSnokeCounterEffect copy() {
        return new SupremeLeaderSnokeCounterEffect(this);
    }
}

