/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostControlledEffect;
import mage.cards.Card;
import mage.cards.s.SurgeToVictoryTriggeredAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class SurgeToVictoryExileEffect
extends OneShotEffect {
    SurgeToVictoryExileEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile target instant or sorcery card from your graveyard. Creatures you control get +X/+0 until end of turn, where X is that card's mana value. Whenever a creature you control deals combat damage to a player this turn, copy the exiled card. You may cast the copy without paying its mana cost";
    }

    private SurgeToVictoryExileEffect(SurgeToVictoryExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public SurgeToVictoryExileEffect copy() {
        return new SurgeToVictoryExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(source.getFirstTarget());
        if (player == null || card == null) {
            return false;
        }
        player.moveCards(card, Zone.EXILED, source, game);
        game.addEffect((ContinuousEffect)new BoostControlledEffect(card.getManaValue(), 0, Duration.EndOfTurn), source);
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new SurgeToVictoryTriggeredAbility(card, game), source);
        return true;
    }
}

