/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.cards.Card;
import mage.cards.s.SurgeToVictoryCastEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.DamagedEvent;
import mage.game.events.GameEvent;

class SurgeToVictoryTriggeredAbility
extends DelayedTriggeredAbility {
    public SurgeToVictoryTriggeredAbility(Card card, Game game) {
        super((Effect)new SurgeToVictoryCastEffect(card, game), Duration.EndOfTurn, false, false);
    }

    private SurgeToVictoryTriggeredAbility(SurgeToVictoryTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        return ((DamagedEvent)event).isCombatDamage() && this.isControlledBy(game.getControllerId(event.getSourceId()));
    }

    public SurgeToVictoryTriggeredAbility copy() {
        return new SurgeToVictoryTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever a creature you control deals combat damage to a player this turn, copy the exiled card. You may cast the copy without paying its mana cost.";
    }
}

