/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class SurvivalCacheEffect
extends OneShotEffect {
    SurvivalCacheEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Then if you have more life than an opponent, draw a card";
    }

    private SurvivalCacheEffect(SurvivalCacheEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player sourcePlayer = game.getPlayer(source.getControllerId());
        if (sourcePlayer != null) {
            boolean haveMoreLife = false;
            for (UUID id : game.getOpponents(source.getControllerId())) {
                Player opponent = game.getPlayer(id);
                if (opponent == null || opponent.getLife() >= sourcePlayer.getLife()) continue;
                haveMoreLife = true;
                break;
            }
            if (haveMoreLife) {
                sourcePlayer.drawCards(1, source, game);
            }
        }
        return false;
    }

    public SurvivalCacheEffect copy() {
        return new SurvivalCacheEffect(this);
    }
}

