/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.LoseLifeTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class SuturePriestSecondTriggeredAbility
extends TriggeredAbilityImpl {
    SuturePriestSecondTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new LoseLifeTargetEffect(1), true);
    }

    private SuturePriestSecondTriggeredAbility(SuturePriestSecondTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public SuturePriestSecondTriggeredAbility copy() {
        return new SuturePriestSecondTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        EntersTheBattlefieldEvent zEvent;
        Permanent card;
        if (game.getOpponents(this.controllerId).contains(event.getPlayerId()) && (card = (zEvent = (EntersTheBattlefieldEvent)event).getTarget()) != null && card.isCreature(game)) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(event.getPlayerId()));
            }
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever a creature an opponent controls enters, you may have that player lose 1 life.";
    }
}

